; -- HP Vectra N2/M2 486 RAM tweaker option ROM --
;
; Lowers RAM waitstates and sets optimal refresh settings for
; a tiny performance boost.
; 
; Requires 60ns (or lower) FPM RAM that supports slow refresh (125uS)
;
; When assembled, the last byte of the ROM (offset 511) must cointain
; a calculated checksum byte so that the whole byte-summed image results
; in zero.
;
;
; - by 8bitbubsy, dec. 2025

RAMTMG	EQU 01h
NTBREF	EQU 05h
CACHCTL	EQU 19h

	ORG 0
	
	DW 0AA55h	; option ROM signature
	DB 1		; option ROM size (1x 512-byte block)
	
	; turn off interrupts
	cli
	
	; unprotect chipset registers
	xor al,al
	out 0FBh,al

	; test for presence of L2 cache
	mov al,CACHCTL
	call ReadChipset
	test ah,00000111b
	setz bl
	shl bl,1 ; bl = 2 if no L2 cache, 0 if L2 cache

	; enable decoupled refresh, CAS-before-RAS refresh and slow refresh
	mov al,NTBREF
	call ReadChipset
	and ah,11110000b
	 or ah,00001011b
	call WriteChipset

	; set lowest RAM waitstates
	mov al,RAMTMG
	call ReadChipset
	and ah,11000000b
	or ah,bl ; custom waitstate setting if no L2 cache (needed)
	call WriteChipset

	; protect chipset registers
	xor al,al
	out 0F9h,al
	
	; turn on interrupts
	sti

	; return to BIOS
	retf

	;  input: al = configuration index address
	; output: ah = data
ReadChipset:
	mov ah,al	
	out 0ECh,al
	in al,0EDh
	xchg al,ah	
	ret

	; input: al = configuration index address
	; input: ah = data
WriteChipset:
	out 0ECh,al
	xchg al,ah
	out 0EDh,al
	xchg al,ah
	ret
	
	DB 512-($-$$) DUP(0)
